package com.ben.utils.ext

import android.content.BroadcastReceiver
import android.content.Context
import android.content.IntentFilter
import com.ben.utils.receiver.BaseBroadcastReceiver

/**
 * @author bin.yang
 * @date 2020/9/19
 * @maintainer bin.yang
 * @copyright 2020 Inc. All rights reserved.
 * @desc:
 */
fun Context.registerReceiverSafety(receiver: BroadcastReceiver?, intentFilter: IntentFilter?) {
    tryCatch { receiver?.also { registerReceiver(it, intentFilter) } }
}

fun Context.registerReceiverSafety(receiver: BaseBroadcastReceiver?) {
    tryCatch { receiver?.also { registerReceiver(it, it.intentFilter) } }
}

fun Context.unregisterReceiverSafety(receiver: BroadcastReceiver?) {
    tryCatch { receiver?.also { unregisterReceiver(it) } }
}
