package com.ben.utils.flow

import com.ben.utils.ext.launchIO
import com.ben.utils.ext.launchMain
import kotlinx.coroutines.CoroutineName
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Job

/**
 * Author: bin.yang
 * Maintainer: bin.yang
 * Date: 2021/10/20
 * Copyright: 2021 Inc. All rights reserved.
 * Desc:
 */
object GlobalFlowScope {

    val scope = CoroutineScope(CoroutineName(GlobalFlowScope::class.java.name))

    fun launchMain(delayTime: Long = 0L, func: suspend CoroutineScope.() -> Unit): Job {
        return scope.launchMain(delayTime, func)
    }

    fun launchIO(delayTime: Long = 0L, func: suspend CoroutineScope.() -> Unit): Job {
        return scope.launchIO(delayTime, func)
    }
}
