package com.ben.utils.mvvm

import android.os.Bundle
import androidx.annotation.CallSuper
import androidx.annotation.LayoutRes
import androidx.annotation.MainThread
import androidx.appcompat.app.AppCompatActivity
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider

open class BaseActivity : AppCompatActivity() {

    fun <V : ViewDataBinding> setViewBinding(@LayoutRes layoutResID: Int): V {
        return DataBindingUtil.setContentView(this, layoutResID)
    }

    @MainThread
    protected fun <T : ViewModel> getViewModel(modelClass: Class<T>): T {
        return ViewModelProvider(this)[modelClass]
    }

    final override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        onCreateView()
        initView(savedInstanceState)
        registerListener()
    }

    protected open fun onCreateView() {

    }

    @CallSuper
    override fun onDestroy() {
        unRegisterListener()
        super.onDestroy()
    }

    protected open fun initView(savedInstanceState: Bundle?) {

    }

    protected open fun registerListener() {

    }

    protected open fun unRegisterListener(){

    }
}