package com.ben.utils.mvvm

import android.os.Bundle
import android.view.View
import androidx.annotation.CallSuper
import androidx.fragment.app.Fragment

open class BaseFragment : Fragment() {

    final override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        initView(savedInstanceState)
        registerListener()
    }

    @CallSuper
    override fun onDestroy() {
        unRegisterListener()
        super.onDestroy()
    }

    protected open fun initView(savedInstanceState: Bundle?) {

    }

    protected open fun registerListener() {

    }

    protected open fun unRegisterListener() {

    }

}