package com.ben.utils.common

import com.ben.utils.log.Logger

/**
 * @author bin.yang
 * @date 2022/3/30 15:27
 * @maintainer bin.yang
 * @copyright 2021 Inc. All rights reserved.
 * @desc:
 */
object FastClickUtils {
    private const val TAG = "SceneUtils"

    /**
     * 上次点击时间
     */
    private var lastClickTime: Long = 0

    /**
     * 默认限制0.5秒内按钮只能点击一次
     * @param delayTime 连续触发的时间间隔
     * @return false=没有连击
     * true=连击
     */
    fun isFastDoubleClick(delayTime: Int = 500): Boolean {
        try {
            val time = System.currentTimeMillis()
            val timeD: Long = time - lastClickTime
            Logger.d(TAG, " --------- timeD:$timeD")
            lastClickTime = time
            if (timeD in 1 until delayTime) {
                return true
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return false
    }
}
