package com.ben.utils.concurrent;

import org.jetbrains.annotations.NotNull;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author bin.yang
 * Maintainer: bin.yang
 * Date: 2018/3/5
 * Copyright: 2018 Inc. All rights reserved.
 * Desc:
 */
public class ThreadPoolUtils {
    private final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private final int CORE_POOL_SIZE = CPU_COUNT + 1;
    private final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    private final int KEEP_ALIVE = 1;
    private Runnable runnable;

    private final ThreadFactory factory = new ThreadFactory() {
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(@NotNull Runnable runnable) {
            String THREAD_NAME = "Thread_1";
            return new Thread(runnable, THREAD_NAME + " #" + mCount.getAndIncrement());
        }
    };
    private final BlockingQueue<Runnable> sPoolWorkQueue =
            new LinkedBlockingQueue<>(64);
    private final Executor mThreadPool = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, KEEP_ALIVE,
            TimeUnit.SECONDS, sPoolWorkQueue, factory);
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(CORE_POOL_SIZE, factory);
    private static ThreadPoolUtils mExecutor;

    public static synchronized ThreadPoolUtils getInstance() {
        if (mExecutor == null) {
            mExecutor = new ThreadPoolUtils();
        }
        return mExecutor;
    }

    public void cancel() {
        if (runnable != null) {
            scheduledThreadPoolExecutor.remove(runnable);
        }
    }

    public void execute(Runnable runnable) {
        try {
            mThreadPool.execute(runnable);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void scheduled(Runnable runnable, long delay) {
        try {
            scheduledThreadPoolExecutor.schedule(runnable, delay, TimeUnit.MILLISECONDS);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void scheduleAtFixedRate(Runnable runnable, long delay, long period) {
        this.runnable = runnable;
        try {
            scheduledThreadPoolExecutor.scheduleAtFixedRate(runnable, delay, period, TimeUnit.MILLISECONDS);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
