package com.ben.utils.ext

import android.annotation.SuppressLint
import android.content.Context
import android.widget.Toast
import androidx.annotation.StringRes

/**
 * @author bin.yang
 * @date 2019/11/26
 * @maintainer bin.yang
 * @copyright 2019 Inc. All rights reserved.
 * @desc:
 */
@SuppressLint("AvoidUsageApiCheck")
fun Context.showToast(content: String, duration: Int = Toast.LENGTH_SHORT) {
    Toast.makeText(this, content, duration).show()
}

@SuppressLint("AvoidUsageApiCheck")
fun Context.showToast(@StringRes id: Int, duration: Int = Toast.LENGTH_SHORT) {
    showToast(getString(id), duration)
}

@SuppressLint("AvoidUsageApiCheck")
fun Context.showLongToast(content: String) {
    showToast(content, Toast.LENGTH_LONG)
}

@SuppressLint("AvoidUsageApiCheck")
fun Context.showLongToast(@StringRes id: Int) {
    showToast(id, Toast.LENGTH_LONG)
}

@SuppressLint("AvoidUsageApiCheck")
fun Any.showToast(context: Context, content: String, duration: Int = Toast.LENGTH_SHORT) {
    context.showToast(content, duration)
}

@SuppressLint("AvoidUsageApiCheck")
fun Any.showToast(context: Context, @StringRes id: Int, duration: Int = Toast.LENGTH_SHORT) {
    context.showToast(id, duration)
}

@SuppressLint("AvoidUsageApiCheck")
fun Any.showLongToast(context: Context, content: String) {
    context.showLongToast(content)
}

@SuppressLint("AvoidUsageApiCheck")
fun Any.showLongToast(context: Context, @StringRes id: Int) {
    context.showLongToast(id)
}
