package com.ben.utils.pkg

import android.content.Context

/**
 * @author bin.yang
 * @time 2022/02/25 17:22
 * @description
 */
object VersionUtils {
    /**
     * 获取程序的版本号
     */
    fun getVersionName(context: Context): String {
        val pm = context.packageManager
        try {
            val packInfo = pm.getPackageInfo(context.packageName, 0)
            return packInfo.versionName
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return ""
    }

    /**
     * 获取程序的版本号
     */
    fun getVersionCode(context: Context): Int {
        val pm = context.packageManager
        try {
            val packInfo = pm.getPackageInfo(context.packageName, 0)
            return packInfo.versionCode
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return 0
    }
}
