package com.ben.utils.receiver

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter

/**
 * @author bin.yang
 * @date 2020/4/11
 * @maintainer bin.yang
 * @copyright 2020 Inc. All rights reserved.
 * @desc:
 */
abstract class BaseBroadcastReceiver : BroadcastReceiver() {

    abstract fun onReceive(context: Context, intent: Intent, action: String?)

    abstract val intentAction: Array<String>

    val intentFilter: IntentFilter
        get() {
            val intentFilter = IntentFilter()
            intentAction.forEach { intentFilter.addAction(it) }
            return intentFilter
        }

    override fun onReceive(context: Context?, intent: Intent?) {
        context ?: return
        intent ?: return
        onReceive(context, intent, intent.action)
    }
}