/*
 * Copyright (c) 2011-2016, Data Geekery GmbH (http://www.datageekery.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ben.utils.reflect

import java.lang.RuntimeException

/**
 * A unchecked wrapper for any of Java's checked reflection exceptions:
 *
 *
 * These exceptions are
 *
 *  *  [ClassNotFoundException]
 *  *  [IllegalAccessException]
 *  *  [IllegalArgumentException]
 *  *  [InstantiationException]
 *  *  [InvocationTargetException]
 *  *  [NoSuchMethodException]
 *  *  [NoSuchFieldException]
 *  *  [SecurityException]
 *
 *
 * @author Lukas Eder
 */
class ReflectException : RuntimeException {
    constructor(message: String?) : super(message) {}
    constructor(message: String?, cause: Throwable?) : super(message, cause) {}
    constructor() : super() {}
    constructor(cause: Throwable?) : super(cause) {}

    companion object {
        /**
         * Generated UID
         */
        private const val serialVersionUID = -6213149635297151442L
    }
}