package com.ben.utils.sound;

import android.content.Context;
import android.media.MediaPlayer;

/**
 * 播放音效类.
 */
public class SoundPlayerHelper implements MediaPlayer.OnPreparedListener, MediaPlayer.OnCompletionListener {

    private MediaPlayer mMediaplayer;

    private static class SoundPlayerHelperBuilder {
        private static SoundPlayerHelper mInstance = new SoundPlayerHelper();
    }

    private SoundPlayerHelper() {
    }

    public static SoundPlayerHelper getInstance() {
        return SoundPlayerHelperBuilder.mInstance;
    }

    public void play(Context context, int resId) {
        try {
            if (mMediaplayer != null) {
                pauseMusic();
                mMediaplayer.reset();
            }
            mMediaplayer = MediaPlayer.create(context, resId);
            mMediaplayer.setOnPreparedListener(this);
            mMediaplayer.setOnCompletionListener(this);
            mMediaplayer.prepare();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void play(Context context, int resId, MediaPlayer.OnCompletionListener onCompletionListener) {
        try {
            if (mMediaplayer != null) {
                pauseMusic();
                mMediaplayer.reset();
            }
            mMediaplayer = MediaPlayer.create(context, resId);
            mMediaplayer.setOnPreparedListener(this);
            mMediaplayer.setOnCompletionListener(onCompletionListener);
            mMediaplayer.prepare();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void play(final String path) {
        try {
            if (mMediaplayer == null) {
                mMediaplayer = new MediaPlayer();
                mMediaplayer.setOnPreparedListener(this);
                mMediaplayer.setOnCompletionListener(this);
            } else {
                mMediaplayer.reset();
            }
            mMediaplayer.setDataSource(path);
            mMediaplayer.prepare();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isPlaying() {
        if (mMediaplayer == null) {
            return false;
        }
        return mMediaplayer.isPlaying();
    }

    public void pauseMusic() {
        try {
            if (mMediaplayer != null && isPlaying()) {
                mMediaplayer.pause();
            }
        } catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void stopMusic() {
        try {
            if (mMediaplayer != null) {
                mMediaplayer.stop();
                mMediaplayer.release();
                mMediaplayer = null;
            }
        } catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void onPrepared(MediaPlayer mp) {
        mp.start();
    }

    @Override
    public void onCompletion(MediaPlayer mp) {
        // play(mAudioList.get(currentIndex = currentIndex % mAudioList.size()));
        // currentIndex++;
    }
}
