/*
 * Decompiled with CFR 0.152.
 */
package top.yonyong.yconfig.config;

import java.util.List;
import java.util.stream.Collectors;
import top.yonyong.yconfig.config.Config;

public class ConfigContext {
    private List<Config> vals;
    private String group;

    public String getValue(String key) {
        List collect = this.vals.stream().filter(tblConfig -> tblConfig.getKeyName().equals(key)).collect(Collectors.toList());
        if (null == collect || collect.size() == 0) {
            return null;
        }
        return ((Config)collect.get(0)).getKeyValue();
    }

    public List<Config> getVals() {
        return this.vals;
    }

    protected void setVals(List<Config> vals) {
        this.vals = vals;
    }

    public String getGroup() {
        return this.group;
    }

    protected void setGroup(String group) {
        this.group = group;
    }

    public static ConfigContextBuilder builder() {
        return new ConfigContextBuilder();
    }

    public ConfigContextBuilder toBuilder() {
        return new ConfigContextBuilder().vals(this.vals).group(this.group);
    }

    public ConfigContext(List<Config> vals, String group) {
        this.vals = vals;
        this.group = group;
    }

    public ConfigContext() {
    }

    public static class ConfigContextBuilder {
        private List<Config> vals;
        private String group;

        ConfigContextBuilder() {
        }

        public ConfigContextBuilder vals(List<Config> vals) {
            this.vals = vals;
            return this;
        }

        public ConfigContextBuilder group(String group) {
            this.group = group;
            return this;
        }

        public ConfigContext build() {
            return new ConfigContext(this.vals, this.group);
        }

        public String toString() {
            return "ConfigContext.ConfigContextBuilder(vals=" + this.vals + ", group=" + this.group + ")";
        }
    }
}

