/*
 * Decompiled with CFR 0.152.
 */
package top.yonyong.yconfig.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import top.yonyong.yconfig.config.ConfigContext;
import top.yonyong.yconfig.utils.StringUtils;

@Configuration
@ConditionalOnClass(value={ConfigContext.class})
public class ConfigContextAutoConfig {
    @Value(value="${config.center.group:DEFAULT_ENV}")
    private String group;

    @Bean(name={"applicationConfigContext"})
    @Scope(value="singleton")
    @ConditionalOnMissingBean(value={ConfigContext.class})
    public ConfigContext myConfigContext() {
        ConfigContext configContext = ConfigContext.builder().build();
        if (StringUtils.isBlank(this.group)) {
            this.group = "DEFAULT_ENV";
        }
        configContext = configContext.toBuilder().group(this.group).build();
        return configContext;
    }
}

