/*
 * Decompiled with CFR 0.152.
 */
package top.yonyong.yconfig.config.aop;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import top.yonyong.yconfig.config.ConfigContext;
import top.yonyong.yconfig.config.aop.MyConfig;
import top.yonyong.yconfig.utils.DataConverter;
import top.yonyong.yconfig.utils.MySpringContext;
import top.yonyong.yconfig.utils.StringUtils;

@Aspect
@Component
public class SystemConfigAop {
    private static final Logger log = LoggerFactory.getLogger(SystemConfigAop.class);
    @Autowired
    ConfigContext applicationConfigContext;
    @Autowired
    MySpringContext mySpringContext;

    @Pointcut(value="@annotation(top.yonyong.yconfig.config.aop.MyConfig)")
    public void pointcut() {
    }

    @Before(value="pointcut()")
    public void before(JoinPoint joinPoint) {
        this.initStatus();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        MyConfig myConfig = method.getAnnotation(MyConfig.class);
        Class<?> clazz = myConfig.clazz();
        Field[] declaredFields = clazz.getDeclaredFields();
        Object bean = this.mySpringContext.getBean(clazz);
        for (Field declaredField : declaredFields) {
            MyConfig annotation = declaredField.getAnnotation(MyConfig.class);
            if (null == annotation || !StringUtils.isNotBlank(annotation.value())) continue;
            String val = this.getVal(annotation.value());
            if (StringUtils.isBlank(val)) {
                throw new RuntimeException("val can not be null");
            }
            try {
                this.buildMethod(clazz, bean, declaredField, val);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private String getVal(String key) {
        if (StringUtils.isNotBlank(key)) {
            return this.applicationConfigContext.getValue(key);
        }
        return this.applicationConfigContext.getGroup();
    }

    private void buildMethod(Class<?> clz, Object obj, Field field, String propertiedValue) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method m;
        String name = field.getName();
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        String type = field.getGenericType().toString();
        if (type.equals("class java.lang.String")) {
            m = clz.getMethod("set" + name, String.class);
            m.invoke(obj, propertiedValue);
        }
        if (type.equals("class java.lang.Integer")) {
            m = clz.getMethod("set" + name, Integer.class);
            m.invoke(obj, Integer.parseInt(propertiedValue));
        }
        if (type.equals("int")) {
            m = clz.getMethod("set" + name, Integer.TYPE);
            m.invoke(obj, Integer.parseInt(propertiedValue));
        }
        if (type.equals("class java.lang.Boolean")) {
            m = clz.getMethod("set" + name, Boolean.class);
            if (propertiedValue.equalsIgnoreCase("true")) {
                m.invoke(obj, true);
            }
            if (propertiedValue.equalsIgnoreCase("false")) {
                m.invoke(obj, true);
            }
        }
        if (type.equals("boolean")) {
            m = clz.getMethod("set" + name, Boolean.TYPE);
            if (propertiedValue.equalsIgnoreCase("true")) {
                m.invoke(obj, true);
            }
            if (propertiedValue.equalsIgnoreCase("false")) {
                m.invoke(obj, true);
            }
        }
        if (type.equals("class java.lang.Long")) {
            m = clz.getMethod("set" + name, Long.class);
            m.invoke(obj, Long.parseLong(propertiedValue));
        }
        if (type.equals("long")) {
            m = clz.getMethod("set" + name, Long.TYPE);
            m.invoke(obj, Long.parseLong(propertiedValue));
        }
        if (type.equals("class java.util.Date")) {
            m = clz.getMethod("set" + name, Date.class);
            m.invoke(obj, DataConverter.convert(propertiedValue));
        }
    }

    private boolean initStatus() {
        boolean rs;
        boolean bl = rs = null != this.applicationConfigContext.getVals() && this.applicationConfigContext.getVals().size() != 0;
        if (!rs) {
            throw new RuntimeException("you must need to init config container:you can implement the method 'int setVals(List<Config> vals)' in class AbstractYConfigHandler to init config container");
        }
        return true;
    }
}

