/*
 * Decompiled with CFR 0.152.
 */
package top.yonyong.yconfig.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DataConverter {
    private static final List<String> formarts = new ArrayList<String>(4);

    public static Date convert(String source) {
        String value = source.trim();
        if ("".equals(value)) {
            return null;
        }
        if (source.matches("^\\d{4}-\\d{1,2}$")) {
            return DataConverter.parseDate(source, formarts.get(0));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2}$")) {
            return DataConverter.parseDate(source, formarts.get(1));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$")) {
            return DataConverter.parseDate(source, formarts.get(2));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$")) {
            return DataConverter.parseDate(source, formarts.get(3));
        }
        throw new IllegalArgumentException("Invalid boolean value '" + source + "'");
    }

    public static Date parseDate(String dateStr, String format) {
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            date = dateFormat.parse(dateStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    static {
        formarts.add("yyyy-MM");
        formarts.add("yyyy-MM-dd");
        formarts.add("yyyy-MM-dd hh:mm");
        formarts.add("yyyy-MM-dd hh:mm:ss");
    }
}

