/*
 * Decompiled with CFR 0.152.
 */
package top.yonyong.yconfig.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class MySpringContext
implements ApplicationContextAware,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(MySpringContext.class);
    private static ApplicationContext applicationContext;

    public static ApplicationContext getApplicationContext() {
        MySpringContext.assertContextInjected();
        return applicationContext;
    }

    public static <T> T getBean(String name) {
        MySpringContext.assertContextInjected();
        return (T)applicationContext.getBean(name);
    }

    public <T> T getBean(Class<T> clazz) {
        MySpringContext.assertContextInjected();
        return (T)applicationContext.getBean(clazz);
    }

    public void destroy() throws Exception {
        logger.debug("\u6e05\u9664 MySpringContext \u4e2d\u7684 ApplicationContext: {}", (Object)applicationContext);
        applicationContext = null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        MySpringContext.applicationContext = applicationContext;
    }

    private static void assertContextInjected() {
        if (null == applicationContext) {
            throw new RuntimeException("applicationContext \u5c5e\u6027\u672a\u6ce8\u5165\uff0c\u8bf7\u5728 spring-context.xml \u914d\u7f6e\u4e2d\u5b9a\u4e49 MySpringContext");
        }
    }

    public void refresh(Class clazz) {
        AnnotationConfigServletWebServerApplicationContext configApplicationContext = (AnnotationConfigServletWebServerApplicationContext)applicationContext;
    }

    public static String enCaptureName(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] + 32);
        return String.valueOf(cs);
    }
}

