/*
 * Decompiled with CFR 0.152.
 */
package top.yonyong.sirius.exception;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import top.yonyong.sirius.exception.Code;
import top.yonyong.sirius.exception.ExcetionInfoUtil;
import top.yonyong.sirius.exception.MyException;
import top.yonyong.sirius.exception.Result;

@RestControllerAdvice
public class MyExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(MyExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public Result<?> handle(Exception e, HttpServletRequest request) {
        if (e instanceof MyException) {
            MyException myException = (MyException)e;
            return Result.error(Code.ACE_EXCEPTION, myException.getResult().toString());
        }
        if (e instanceof ClassCastException) {
            return Result.error(Code.ACE_EXCEPTION, "convert exception");
        }
        log.error("error: {}\n{}", (Object)e.getMessage(), (Object)ExcetionInfoUtil.getExceptionInformation(e));
        return Result.error(e.toString());
    }

    @ExceptionHandler(value={BindException.class})
    public Result<?> handlerBindException(BindException exception) {
        return this.handlerNotValidException((Exception)exception);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<?> handlerArgumentNotValidException(MethodArgumentNotValidException exception) {
        return this.handlerNotValidException((Exception)exception);
    }

    public Result<?> handlerNotValidException(Exception e) {
        HashMap maps;
        BindingResult result;
        BindException exception;
        if (e instanceof BindException) {
            exception = (BindException)e;
            result = exception.getBindingResult();
        } else {
            exception = (MethodArgumentNotValidException)e;
            result = exception.getBindingResult();
        }
        String message = null;
        if (result.hasErrors()) {
            List fieldErrors = result.getFieldErrors();
            maps = new HashMap(fieldErrors.size());
            fieldErrors.forEach(error -> maps.put(error.getField(), error.getDefaultMessage()));
            message = ((FieldError)fieldErrors.get(0)).getDefaultMessage();
        } else {
            maps = Collections.EMPTY_MAP;
        }
        return Result.error(message);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result<?> handlerConstraintViolationException(ConstraintViolationException exception) {
        String message = ((ConstraintViolation)exception.getConstraintViolations().iterator().next()).getMessage();
        return Result.error(Code.ACE_COMMON_FAIL, message);
    }
}

