/*
 * Decompiled with CFR 0.152.
 */
package top.yonyong.spring.cache.plus.client.redis;

import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import top.yonyong.spring.cache.plus.client.YangCacheTemplate;

@Component
@ConditionalOnProperty(prefix="system.cache.client.redis", name={"enable"}, havingValue="true", matchIfMissing=true)
public class RedisCacheTemplate
implements YangCacheTemplate {
    private final RedisTemplate<String, Object> yangRedisTemplate;

    @Override
    public boolean exist(String key) {
        return this.yangRedisTemplate.hasKey((Object)key);
    }

    @Override
    public boolean set(String key, Object value, long time, TimeUnit timeUnit) {
        System.out.println(String.format("\u3010\u6dfb\u52a0\u7f13\u5b58\u3011key\uff1a%s,value:%s,time:%s,timeUnit:%s", new Object[]{key, value, time, timeUnit}));
        this.yangRedisTemplate.opsForValue().set((Object)key, value, time, timeUnit);
        return false;
    }

    @Override
    public boolean del(String key) {
        System.out.println(String.format("\u3010\u5220\u9664\u7f13\u5b58\u3011key\uff1a%s", key));
        this.yangRedisTemplate.delete((Object)key);
        return false;
    }

    @Override
    public Object get(String key) {
        System.out.println(String.format("\u3010\u67e5\u8be2\u7f13\u5b58\u3011key\uff1a%s", key));
        return this.yangRedisTemplate.opsForValue().get((Object)key);
    }

    public RedisCacheTemplate(RedisTemplate<String, Object> yangRedisTemplate) {
        this.yangRedisTemplate = yangRedisTemplate;
    }
}

