/*
 * Decompiled with CFR 0.152.
 */
package top.yonyong.spring.cache.plus.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.DefaultParameterNameDiscoverer;

public class AspectUtil {
    public static <T extends Annotation> T getAnnotation(ProceedingJoinPoint point, Class<T> annotationClass) throws NoSuchMethodException {
        Object target = point.getTarget();
        Signature signature = point.getSignature();
        MethodSignature methodSignature = null;
        if (!(signature instanceof MethodSignature)) {
            throw new IllegalArgumentException("\u8be5\u6ce8\u89e3\u53ea\u80fd\u7528\u4e8e\u65b9\u6cd5");
        }
        methodSignature = (MethodSignature)signature;
        Method currentMethod = target.getClass().getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        return currentMethod.getDeclaredAnnotation(annotationClass);
    }

    public static LinkedHashMap<String, Object> getParams(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Object[] arguments = joinPoint.getArgs();
        String[] paramNames = AspectUtil.getParameterNames(method);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        for (int i = 0; i < arguments.length; ++i) {
            params.put(paramNames[i], arguments[i]);
        }
        return params;
    }

    private static String[] getParameterNames(Method method) {
        DefaultParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
        return parameterNameDiscoverer.getParameterNames(method);
    }
}

