/*
 * Decompiled with CFR 0.152.
 */
package top.yonyong.spring.cache.plus.aspect;

import java.util.LinkedHashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.Ordered;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;
import top.yonyong.spring.cache.plus.annotation.CacheDel;
import top.yonyong.spring.cache.plus.annotation.CacheGet;
import top.yonyong.spring.cache.plus.annotation.CacheSet;
import top.yonyong.spring.cache.plus.client.YangCacheTemplate;
import top.yonyong.spring.cache.plus.util.AspectUtil;
import top.yonyong.spring.cache.plus.util.ELUtil;

@Aspect
@Component
@ConditionalOnProperty(prefix="system.cache.aop", name={"enable"}, havingValue="true", matchIfMissing=true)
public class CachePointcut
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(CachePointcut.class);
    private final YangCacheTemplate cacheTemplate;

    @Pointcut(value="@annotation(top.yonyong.spring.cache.plus.annotation.CacheGet)")
    private void cacheGet() {
    }

    @Pointcut(value="@annotation(top.yonyong.spring.cache.plus.annotation.CacheSet)")
    private void cacheSet() {
    }

    @Pointcut(value="@annotation(top.yonyong.spring.cache.plus.annotation.CacheDel),")
    private void cacheDel() {
    }

    @Around(value="cacheGet()")
    public Object handleCacheGet(ProceedingJoinPoint point) throws Throwable {
        StandardEvaluationContext context;
        CacheGet cacheGet = AspectUtil.getAnnotation(point, CacheGet.class);
        String condition = cacheGet.condition();
        if (ELUtil.parseCondition(condition, (EvaluationContext)(context = this.buildContext(point)))) {
            String key = cacheGet.key();
            String cacheKey = cacheGet.prefix() + ELUtil.parse(key, (EvaluationContext)context);
            if (this.cacheTemplate.exist(cacheKey)) {
                return this.cacheTemplate.get(cacheKey);
            }
            if (cacheGet.selectIfNull()) {
                Object result = point.proceed();
                if (null != result && cacheGet.setIfNull()) {
                    this.cacheTemplate.set(cacheKey, result, cacheGet.timeout(), cacheGet.timeunit());
                }
                return result;
            }
            return null;
        }
        return point.proceed();
    }

    @Around(value="cacheSet()")
    public Object handleCachePet(ProceedingJoinPoint point) throws Throwable {
        StandardEvaluationContext context;
        CacheSet cacheSet = AspectUtil.getAnnotation(point, CacheSet.class);
        Object result = point.proceed();
        String condition = cacheSet.condition();
        if (ELUtil.parseCondition(condition, (EvaluationContext)(context = this.buildContext(point))) && null != result) {
            String key = cacheSet.key();
            String cacheKey = cacheSet.prefix() + ELUtil.parse(key, (EvaluationContext)context);
            this.cacheTemplate.set(cacheKey, result, cacheSet.timeout(), cacheSet.timeunit());
        }
        return point.proceed();
    }

    @Around(value="cacheDel()")
    public Object handleCacheDel(ProceedingJoinPoint point) throws Throwable {
        StandardEvaluationContext context;
        CacheDel cachePut = AspectUtil.getAnnotation(point, CacheDel.class);
        String condition = cachePut.condition();
        if (ELUtil.parseCondition(condition, (EvaluationContext)(context = this.buildContext(point)))) {
            String key = cachePut.key();
            String cacheKey = cachePut.prefix() + ELUtil.parse(key, (EvaluationContext)context);
            if (this.cacheTemplate.exist(cacheKey)) {
                this.cacheTemplate.del(cacheKey);
            }
        }
        return point.proceed();
    }

    public int getOrder() {
        return 1;
    }

    private StandardEvaluationContext buildContext(ProceedingJoinPoint point) {
        LinkedHashMap<String, Object> params = AspectUtil.getParams(point);
        StandardEvaluationContext context = ELUtil.getContext();
        if (params.size() == 1) {
            params.forEach((k, v) -> context.setRootObject(v));
        }
        int i = 0;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            context.setVariable(entry.getKey(), entry.getValue());
            context.setVariable("a" + i, entry.getValue());
            context.setVariable("p" + i, entry.getValue());
            ++i;
        }
        return context;
    }

    public CachePointcut(YangCacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }
}

