/*
 * Decompiled with CFR 0.152.
 */
package top.yonyong.spring.cache.plus.client.redis;

import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import top.yonyong.spring.cache.plus.client.YangCacheTemplate;

@Component
@ConditionalOnProperty(prefix="system.cache.client.redis", name={"enable"}, havingValue="true", matchIfMissing=true)
public class RedisCacheTemplate
implements YangCacheTemplate {
    private final RedisTemplate<String, Object> yangRedisTemplate;

    @Override
    public boolean exist(String key) {
        return this.yangRedisTemplate.hasKey((Object)key);
    }

    @Override
    public boolean set(String key, Object value, long time, TimeUnit timeUnit) {
        this.yangRedisTemplate.opsForValue().set((Object)key, value, time, timeUnit);
        return false;
    }

    @Override
    public boolean del(String key) {
        this.yangRedisTemplate.delete((Object)key);
        return false;
    }

    @Override
    public Object get(String key) {
        return this.yangRedisTemplate.opsForValue().get((Object)key);
    }

    public RedisCacheTemplate(RedisTemplate<String, Object> yangRedisTemplate) {
        this.yangRedisTemplate = yangRedisTemplate;
    }
}

