/*
 * Decompiled with CFR 0.152.
 */
package top.yuuma.word.write;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import top.yuuma.word.write.EasyWordTableWriter;
import top.yuuma.word.write.EasyWordTextWriter;

public class EasyWordWriter {
    private EasyWordTextWriter textWriter;
    private EasyWordTableWriter tableWriter;
    private XWPFDocument document;

    public static EasyWordWriter of(XWPFDocument document) {
        EasyWordWriter writer = new EasyWordWriter();
        writer.document = document;
        writer.textWriter = new EasyWordTextWriter("\\$\\{([^}]+)}");
        writer.tableWriter = new EasyWordTableWriter("\\$\\{([^}]+)}");
        return writer;
    }

    public EasyWordWriter replacePlaceholders(Map<String, Object> params) {
        this.textWriter.replaceTextPlaceholders(this.document, params);
        this.tableWriter.replaceTablePlaceholders(this.document, params);
        return this;
    }

    public EasyWordWriter replacePlaceholders(Map<String, Object> params, String regex) {
        this.textWriter.setRegex(regex);
        this.tableWriter.setRegex(regex);
        this.textWriter.replaceTextPlaceholders(this.document, params);
        this.tableWriter.replaceTablePlaceholders(this.document, params);
        return this;
    }

    public void export(OutputStream outputStream) throws IOException {
        this.document.write(outputStream);
    }

    public ByteArrayOutputStream exportToStream() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.document.write((OutputStream)outputStream);
        return outputStream;
    }
}

