/*
 * Decompiled with CFR 0.152.
 */
package top.yuuma.word.handler;

import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class RunsStyleHandler {
    public static void preserveAndSetText(XWPFRun run, String newText) {
        boolean isBold = run.isBold();
        boolean isItalic = run.isItalic();
        boolean hasUnderline = run.getUnderline() != UnderlinePatterns.NONE;
        boolean isStrike = run.isStrikeThrough();
        UnderlinePatterns underlinePattern = run.getUnderline();
        String fontFamily = run.getFontFamily();
        Double fontSize = run.getFontSizeAsDouble();
        String color = run.getColor();
        run.setText(newText, 0);
        run.setBold(isBold);
        run.setItalic(isItalic);
        if (hasUnderline) {
            run.setUnderline(underlinePattern);
        }
        run.setStrikeThrough(isStrike);
        if (fontFamily != null) {
            run.setFontFamily(fontFamily);
        }
        if (fontSize != null && fontSize != -1.0) {
            run.setFontSize(fontSize.doubleValue());
        }
        if (color != null) {
            run.setColor(color);
        }
    }
}

