/*
 * Decompiled with CFR 0.152.
 */
package top.yuuma.word.write;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import top.yuuma.word.handler.RunsStyleHandler;

public class EasyWordTableWriter {
    private String regex;

    public EasyWordTableWriter(String regex) {
        this.regex = regex;
    }

    public void replaceTablePlaceholders(XWPFDocument document, Map<String, Object> params) {
        List tables = document.getTables();
        for (XWPFTable table : tables) {
            this.processTable(table, params);
        }
    }

    private void processTable(XWPFTable table, Map<String, Object> params) {
        for (XWPFTableRow row : table.getRows()) {
            for (XWPFTableCell cell : row.getTableCells()) {
                for (XWPFParagraph paragraph : cell.getParagraphs()) {
                    List runs = paragraph.getRuns();
                    for (XWPFRun run : runs) {
                        String newText;
                        String originalText;
                        if (run.getText(0) == null || (originalText = run.getText(0)).equals(newText = this.replacePlaceholders(originalText, params))) continue;
                        RunsStyleHandler.preserveAndSetText(run, newText);
                    }
                }
            }
        }
    }

    private String replacePlaceholders(String text, Map<String, Object> params) {
        Pattern pattern = Pattern.compile(this.regex);
        Matcher matcher = pattern.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String field = matcher.group(1);
            Object value = params.get(field);
            String replacement = value != null ? value.toString() : "";
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }
}

