/*
 * Decompiled with CFR 0.152.
 */
package top.yuuma.word.write;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import top.yuuma.word.handler.RunsStyleHandler;

public class EasyWordTextWriter {
    private String regex;

    public EasyWordTextWriter(String regex) {
        this.regex = regex;
    }

    public void replaceTextPlaceholders(XWPFDocument document, Map<String, Object> params) {
        List paragraphs = document.getParagraphs();
        for (XWPFParagraph paragraph : paragraphs) {
            this.processParagraph(paragraph, params);
        }
    }

    private void processParagraph(XWPFParagraph paragraph, Map<String, Object> params) {
        List runs = paragraph.getRuns();
        for (XWPFRun run : runs) {
            String newText;
            String runText = run.getText(0);
            if (runText == null || runText.equals(newText = this.replacePlaceholders(runText, params))) continue;
            RunsStyleHandler.preserveAndSetText(run, newText);
        }
    }

    private String replacePlaceholders(String text, Map<String, Object> params) {
        Pattern pattern = Pattern.compile(this.regex);
        Matcher matcher = pattern.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String field = matcher.group(1);
            Object value = params.get(field);
            String replacement = value != null ? value.toString() : "";
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }
}

