/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.datas.encrypts;

import com.yuzhyn.azylee.core.datas.encrypts.Md5Tool;
import com.yuzhyn.azylee.core.datas.exceptions.ExceptionTool;
import com.yuzhyn.azylee.core.datas.strings.StringFillTool;
import com.yuzhyn.azylee.core.datas.strings.StringTool;
import com.yuzhyn.azylee.core.logs.Alog;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class DesTool {
    private static final String IV_PARAMETER = "12345678";
    private static final String ALGORITHM = "DES";
    private static final String CIPHER_ALGORITHM = "DES/CBC/PKCS5Padding";
    private static final String CHARSET = "utf-8";
    private static final String FILL_CHAR = "Y";

    private static Key generateKey(String key) throws Exception {
        key = StringFillTool.suffixFill(key, 8, FILL_CHAR);
        DESKeySpec dks = new DESKeySpec(key.getBytes(CHARSET));
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        return keyFactory.generateSecret(dks);
    }

    public static byte[] encrypt(byte[] data, String key) {
        try {
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(key.getBytes());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            SecretKey securekey = keyFactory.generateSecret(desKey);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, (Key)securekey, random);
            return cipher.doFinal(data);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encrypt(String text, String key) {
        if (StringTool.ok(text, key)) {
            try {
                byte[] bytes = DesTool.encrypt(text.getBytes(CHARSET), key);
                return new String(Base64.getEncoder().encode(bytes));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return text;
    }

    public static byte[] decrypt(byte[] data, String key) throws Exception {
        SecureRandom random = new SecureRandom();
        DESKeySpec desKey = new DESKeySpec(key.getBytes());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        SecretKey securekey = keyFactory.generateSecret(desKey);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, (Key)securekey, random);
        return cipher.doFinal(data);
    }

    public static String decrypt(String text, String key) {
        if (StringTool.ok(text, key)) {
            try {
                byte[] bytes = DesTool.decrypt(text.getBytes(CHARSET), key);
                return new String(bytes, CHARSET);
            }
            catch (Exception ex) {
                Alog.i("*********************************");
                Alog.e(ExceptionTool.getStackTrace(ex));
                Alog.i("*********************************");
                ex.printStackTrace();
            }
        }
        return text;
    }

    public static void main(String[] args) {
        String name = "\u98de\u96ea\u8fde\u5929\u5c04\u767d\u9e7f";
        String key = "yuzhengyang11111111111111111111111111112222222222222222222222222";
        String xtext = DesTool.encrypt(name, key);
        String dxtext = DesTool.decrypt(xtext, key);
        System.out.println("xtext " + xtext);
        System.out.println("dxtext " + dxtext);
        Alog.i("-------------------------");
        Alog.i(": " + Md5Tool.encrypt(DesTool.encrypt("yuzhengyang", "yuzhengyang")));
        Alog.i(DesTool.decrypt("0AEKBflb5ZkNwVy6qCXTIQ==", IV_PARAMETER));
    }
}

