/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.ios.dirs;

import com.yuzhyn.azylee.core.ios.files.FileTool;
import com.yuzhyn.azylee.core.logs.Alog;
import java.io.File;

public class DirTool {
    public static boolean isExist(String path) {
        try {
            File file = new File(path);
            return file.exists() && file.isDirectory();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String parent(String path) {
        try {
            File file = new File(path);
            String strParentDirectory = file.getParent();
            return strParentDirectory;
        }
        catch (Exception ex) {
            Alog.e(ex.getMessage());
            return path;
        }
    }

    public static boolean create(String path) {
        if (!DirTool.isExist(path)) {
            try {
                File file = new File(path);
                return file.mkdirs();
            }
            catch (Exception ex) {
                Alog.e(ex.getMessage());
                return false;
            }
        }
        return true;
    }

    public static String combine(String path1, String path2) {
        return path1 + File.separator + path2;
    }

    public static boolean delete(String path) {
        File dirFile;
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        if (!(dirFile = new File(path)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = FileTool.delete(files[i].getAbsolutePath())) : files[i].isDirectory() && !(flag = DirTool.delete(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static void main(String[] args) {
        boolean aa = DirTool.delete("D:\\code\\projects\\my-github-projects\\Hidoc\\03_SRC\\hidoc\\hidoc_data\\temp\\20211118\\116682060910821376");
        boolean a = false;
    }
}

