/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.datas.strings;

import com.yuzhyn.azylee.core.datas.collections.ListTool;
import com.yuzhyn.azylee.core.datas.strings.StringConst;
import com.yuzhyn.azylee.core.logs.Alog;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;

public class StringTool {
    public static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean ok(String ... strings) {
        for (String s : strings) {
            if (StringTool.ok(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean has(String s, String ... words) {
        for (String word : words) {
            if (s.contains(word)) continue;
            return false;
        }
        return true;
    }

    public static String reverse(String s) {
        if (null == s) {
            return "";
        }
        char[] chars = s.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = chars.length - 1; i >= 0; --i) {
            stringBuilder.append(chars[i]);
        }
        return stringBuilder.toString();
    }

    public static int startCharSize(String s, char ch) {
        int size = 0;
        for (char c : s.toCharArray()) {
            if (c == ch) {
                ++size;
                continue;
            }
            return size;
        }
        return size;
    }

    public static String retractSpace(String s, int size) {
        if (StringTool.ok(s)) {
            int startSpaceSize = StringTool.startCharSize(s, ' ');
            if (startSpaceSize > 0 && startSpaceSize >= size) {
                return s.substring(size);
            }
            return s.substring(startSpaceSize);
        }
        return "";
    }

    public static String[] splitLine(String s) {
        if (StringTool.ok(s)) {
            String[] lines = s.split("\\r?\\n");
            return lines;
        }
        return new String[]{""};
    }

    public static String[] splitLine(String s, String regex, int size, String combineString, boolean filterSpace) {
        String[] result = new String[size];
        if (StringTool.ok(s)) {
            int pos = 0;
            String[] lines = s.split(regex);
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = lines[i].trim();
                boolean todo = true;
                if (filterSpace) {
                    todo = StringTool.ok(lines[i]);
                }
                if (!todo) continue;
                if (StringTool.ok(result[pos])) {
                    int n = pos;
                    result[n] = result[n] + combineString;
                } else {
                    result[pos] = "";
                }
                int n = pos++;
                result[n] = result[n] + lines[i];
                if (pos < size) continue;
                pos = size - 1;
            }
        }
        return result;
    }

    public static String[] split(String s, String regex, boolean filterSpace, boolean filterRepeat) {
        if (StringTool.ok(s)) {
            String[] array = s.split(regex);
            ArrayList<String> list = new ArrayList<String>();
            for (String item : array) {
                if (filterSpace) {
                    if (!StringTool.ok(item.trim())) continue;
                    list.add(item);
                    continue;
                }
                list.add(item);
            }
            if (!filterRepeat) {
                return list.toArray(new String[list.size()]);
            }
            HashSet<String> sets = new HashSet<String>();
            for (String item : list) {
                sets.add(item);
            }
            return sets.toArray(new String[sets.size()]);
        }
        return null;
    }

    public static String combineArray(String[] lines, String joinString) {
        if (ListTool.ok(lines)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < lines.length; ++i) {
                stringBuilder.append(lines[i]);
                if (i >= lines.length - 1) continue;
                stringBuilder.append(joinString);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static String retractSpaceArrayAuto(String s) {
        String[] lines;
        int spaceSize = Integer.MAX_VALUE;
        for (String line : lines = StringTool.splitLine(s)) {
            int size;
            if (!StringTool.ok(line) || (size = StringTool.startCharSize(line, ' ')) >= spaceSize) continue;
            spaceSize = size;
        }
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = StringTool.retractSpace(lines[i], spaceSize);
        }
        return StringTool.combineArray(lines, StringConst.NEWLINE);
    }

    public static void main(String[] args) {
        BigDecimal num = new BigDecimal("1.5393");
        System.out.println(num);
        String x = "123";
        String y = "null";
        Alog.i(StringTool.ok(x, y, null));
    }
}

