/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.datas.collections;

import com.yuzhyn.azylee.core.datas.collections.ListTool;
import com.yuzhyn.azylee.core.datas.datetimes.LocalDateTimeTool;
import com.yuzhyn.azylee.core.datas.numbers.DoubleTool;
import com.yuzhyn.azylee.core.datas.numbers.IntTool;
import com.yuzhyn.azylee.core.datas.numbers.LongTool;
import com.yuzhyn.azylee.core.logs.Alog;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MapTool {
    public static boolean ok(Map map) {
        return map != null && map.size() > 0;
    }

    public static boolean ok(Map map, String ... keys) {
        if (MapTool.ok(map)) {
            for (String key : keys) {
                if (map.getOrDefault(key, null) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static <K, T> T get(Map<K, T> map, K key, T defaultValue) {
        if (map.containsKey(key)) {
            return Optional.ofNullable(map.getOrDefault(key, defaultValue)).orElse(defaultValue);
        }
        return defaultValue;
    }

    public static <K, T> String getString(Map<K, T> map, K key, T defaultValue) {
        if (map.containsKey(key)) {
            return Optional.ofNullable(map.getOrDefault(key, defaultValue)).orElse(defaultValue).toString();
        }
        return defaultValue.toString();
    }

    public static <K, T> int getInt(Map<K, T> map, K key, T defaultValue) {
        String s = MapTool.getString(map, key, defaultValue);
        return IntTool.parse(s, IntTool.parse(defaultValue.toString(), 0));
    }

    public static <K, T> long getLong(Map<K, T> map, K key, T defaultValue) {
        String s = MapTool.getString(map, key, defaultValue);
        return LongTool.parse(s, LongTool.parse(defaultValue.toString(), 0L));
    }

    public static <K, T> double getDouble(Map<K, T> map, K key, T defaultValue) {
        String s = MapTool.getString(map, key, defaultValue);
        return DoubleTool.parse(s, DoubleTool.parse(defaultValue.toString(), 0.0));
    }

    public static <K, T> boolean getBoolean(Map<K, T> map, K key, T defaultValue) {
        String s = MapTool.getString(map, key, defaultValue);
        return Boolean.valueOf(s);
    }

    public static <K, T> LocalDateTime getLocalDateTime(Map<K, T> map, K key, T defaultValue) {
        String s = MapTool.getString(map, key, null);
        LocalDateTime time = LocalDateTimeTool.parse(s);
        if (time != null) {
            return time;
        }
        return null;
    }

    public static <K, T> List<T> extract(List<Map<K, T>> mapList, K key) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (ListTool.ok(mapList)) {
            for (Map<K, T> map : mapList) {
                if (!MapTool.ok(map)) continue;
                result.add(MapTool.get(map, key, null));
            }
        }
        return result;
    }

    public static void print(Map map) {
        Alog.w("maptool:print");
        if (MapTool.ok(map)) {
            for (Object key : map.keySet()) {
                Alog.i(key + " = " + map.get(key));
            }
        } else {
            Alog.e("maptool:map is null");
        }
    }
}

