/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.datas.keyvalues;

import com.yuzhyn.azylee.core.datas.collections.ArrayTool;
import com.yuzhyn.azylee.core.datas.collections.ListTool;
import com.yuzhyn.azylee.core.datas.objects.ObjectTool;
import com.yuzhyn.azylee.core.datas.strings.StringTool;
import java.util.HashMap;
import java.util.Map;

public class KeyValueBag {
    private Map<String, Object> map = new HashMap<String, Object>();

    public KeyValueBag(String s) {
        if (StringTool.ok(s)) {
            s = s.replaceAll(";", ",");
            s = s.replaceAll("\uff0c", ",");
            String[] keyValues = StringTool.split(s = s.replaceAll("\uff1b", ","), ",", true, true);
            if (ListTool.ok(keyValues)) {
                for (String item : keyValues) {
                    String[] pair = StringTool.splitLine(item, ":", 2, "", false);
                    String key = ArrayTool.get(pair, 0, "");
                    String val = ArrayTool.get(pair, 1, "");
                    this.map.put(key, val);
                }
            }
        }
    }

    public String getString(String key) {
        return ObjectTool.optional(this.map.get(key), "").toString();
    }

    public boolean getBool(String key) {
        String value;
        switch (value = this.getString(key).toLowerCase()) {
            case "1": 
            case "y": 
            case "true": 
            case "yes": 
            case "enable": 
            case "visible": {
                return true;
            }
        }
        return false;
    }

    public void print() {
        for (String key : this.map.keySet()) {
            System.out.println("[" + key + "] : [" + this.map.get(key) + "]");
        }
    }

    public static void main(String[] args) {
        KeyValueBag extOptions = new KeyValueBag("  isOpen  :1 ,   isOpen  :2 ,   isOpen  :tu");
        extOptions.print();
        System.out.println("[isOpen] : [" + extOptions.getBool("isOpen") + "]");
    }
}

