/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.ios.files;

import com.yuzhyn.azylee.core.datas.collections.ListTool;
import com.yuzhyn.azylee.core.ios.dirs.DirTool;
import com.yuzhyn.azylee.core.logs.Alog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileFindTool {
    public static List<String> getFiles(String path) {
        File file;
        File[] fileList;
        ArrayList<String> result = new ArrayList<String>();
        if (DirTool.isExist(path) && ListTool.ok(fileList = (file = new File(path)).listFiles())) {
            for (File f : fileList) {
                if (!f.isFile()) continue;
                result.add(f.getName());
            }
        }
        return result;
    }

    public static List<String> getAllFiles(String path, String ext) {
        ArrayList<String> fileNames = new ArrayList<String>();
        FileFindTool.findFileList(path, fileNames, ext);
        return fileNames;
    }

    private static void findFileList(String filepath, List<String> fileNames, String ext) {
        File dir = new File(filepath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isFile()) {
                String f = DirTool.combine(dir.getPath(), file.getName());
                if (!f.endsWith(ext)) continue;
                fileNames.add(f);
                continue;
            }
            FileFindTool.findFileList(file.getPath(), fileNames, ext);
        }
    }

    public static void main(String[] args) {
        ArrayList<String> files = new ArrayList<String>();
        Alog.i(files);
    }
}

