/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.ios.txts;

import com.yuzhyn.azylee.core.datas.collections.MapTool;
import com.yuzhyn.azylee.core.ios.files.FileTool;
import com.yuzhyn.azylee.core.logs.Alog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.time.LocalDateTime;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class PropertyTool {
    private static final String CHARSET_NAME = "utf-8";

    public static String read(String pathName, String key, String defaultValue) {
        if (FileTool.isExist(pathName)) {
            try {
                Properties properties = new Properties();
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(pathName));
                properties.load(new InputStreamReader((InputStream)in, CHARSET_NAME));
                String value = properties.getProperty(key);
                return Optional.ofNullable(value).orElse(defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Map<String, String> read(String pathName) {
        HashMap<String, String> result = new HashMap<String, String>(10);
        if (FileTool.isExist(pathName)) {
            try {
                Properties properties = new Properties();
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(pathName));
                properties.load(new InputStreamReader((InputStream)in, CHARSET_NAME));
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String name = (String)enumeration.nextElement();
                    String value = properties.getProperty(name);
                    result.put(name, value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean write(String pathName, Map<String, String> props) {
        return PropertyTool.write(pathName, props, "");
    }

    public static boolean write(String pathName, Map<String, String> props, String comments) {
        try {
            if (FileTool.create(pathName) && MapTool.ok(props)) {
                Properties properties = new Properties();
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(pathName));
                properties.load(new InputStreamReader((InputStream)in, CHARSET_NAME));
                File file = new File(pathName);
                FileOutputStream outputStream = new FileOutputStream(file);
                for (String key : props.keySet()) {
                    properties.put(key, props.get(key));
                }
                properties.store(new OutputStreamWriter((OutputStream)outputStream, CHARSET_NAME), comments);
                return true;
            }
        }
        catch (Exception ex) {
            Alog.e(ex.getMessage());
        }
        return false;
    }

    public static void main(String[] args) {
        String config = "d:\\temp\\config.properties";
        Alog.i("[" + PropertyTool.read(config, "name", "\u65e0\u540d\u6c0f") + "]");
        Alog.i("[" + PropertyTool.read(config, "age", "\u4fdd\u5bc6") + "]");
        Alog.i("[" + PropertyTool.read(config, "dept", "\u6c5f\u6e56\u4fa0\u5ba2") + "]");
        Alog.i("[" + PropertyTool.read(config, "so", "...") + "]");
        Alog.i("[" + PropertyTool.read(config, "power", "...") + "]");
        Alog.e();
        Alog.e();
        Map<String, String> props = PropertyTool.read(config);
        MapTool.print(props);
        Alog.e();
        Alog.e();
        HashMap<String, String> pms = new HashMap<String, String>();
        pms.put("age", "" + LocalDateTime.now().getSecond());
        pms.put("car", "\u81ea\u884c\u8f66");
        boolean writeFlag = PropertyTool.write(config, pms);
        Alog.i("writeFlag: " + writeFlag);
    }
}

