/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.datas.strings;

import com.yuzhyn.azylee.core.datas.collections.ListTool;
import com.yuzhyn.azylee.core.datas.strings.StringConst;
import com.yuzhyn.azylee.core.logs.Alog;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class StringTool {
    public static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean ok(String ... strings) {
        for (String s : strings) {
            if (StringTool.ok(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean has(String s, String ... words) {
        for (String word : words) {
            if (s.contains(word)) continue;
            return false;
        }
        return true;
    }

    public static String reverse(String s) {
        if (null == s) {
            return "";
        }
        char[] chars = s.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = chars.length - 1; i >= 0; --i) {
            stringBuilder.append(chars[i]);
        }
        return stringBuilder.toString();
    }

    public static int startCharSize(String s, char ch) {
        int size = 0;
        for (char c : s.toCharArray()) {
            if (c == ch) {
                ++size;
                continue;
            }
            return size;
        }
        return size;
    }

    public static String retractSpace(String s, int size) {
        if (StringTool.ok(s)) {
            int startSpaceSize = StringTool.startCharSize(s, ' ');
            if (startSpaceSize > 0 && startSpaceSize >= size) {
                return s.substring(size);
            }
            return s.substring(startSpaceSize);
        }
        return "";
    }

    public static String[] splitLine(String s) {
        if (StringTool.ok(s)) {
            String[] lines = s.split("\\r?\\n");
            return lines;
        }
        return new String[]{""};
    }

    public static String[] splitLine(String s, String regex, int size, String combineString, boolean filterSpace) {
        String[] result = new String[size];
        if (StringTool.ok(s)) {
            int pos = 0;
            String[] lines = s.split(regex);
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = lines[i].trim();
                boolean todo = true;
                if (filterSpace) {
                    todo = StringTool.ok(lines[i]);
                }
                if (!todo) continue;
                if (StringTool.ok(result[pos])) {
                    int n = pos;
                    result[n] = result[n] + combineString;
                } else {
                    result[pos] = "";
                }
                int n = pos++;
                result[n] = result[n] + lines[i];
                if (pos < size) continue;
                pos = size - 1;
            }
        }
        return result;
    }

    public static String[] split(String s, String regex, boolean filterSpace, boolean filterRepeat, boolean doTrim) {
        if (StringTool.ok(s)) {
            String[] array = s.split(regex);
            ArrayList<String> list = new ArrayList<String>();
            HashSet<String> sets = new HashSet<String>();
            for (String item : array) {
                boolean canAdd = false;
                if (filterSpace) {
                    if (StringTool.ok(item.trim())) {
                        canAdd = true;
                    }
                } else {
                    canAdd = true;
                }
                if (!canAdd) continue;
                if (filterRepeat) {
                    if (sets.contains(item)) continue;
                    list.add(doTrim ? item.trim() : item);
                    sets.add(item);
                    continue;
                }
                list.add(doTrim ? item.trim() : item);
            }
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    public static String combineArray(String[] lines, String joinString) {
        if (ListTool.ok(lines)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < lines.length; ++i) {
                stringBuilder.append(lines[i]);
                if (i >= lines.length - 1) continue;
                stringBuilder.append(joinString);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static String retractSpaceArrayAuto(String s) {
        String[] lines;
        int spaceSize = Integer.MAX_VALUE;
        for (String line : lines = StringTool.splitLine(s)) {
            int size;
            if (!StringTool.ok(line) || (size = StringTool.startCharSize(line, ' ')) >= spaceSize) continue;
            spaceSize = size;
        }
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = StringTool.retractSpace(lines[i], spaceSize);
        }
        return StringTool.combineArray(lines, StringConst.NEWLINE);
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (StringTool.ok(inString) && StringTool.ok(oldPattern) && newPattern != null) {
            int index = inString.indexOf(oldPattern);
            if (index == -1) {
                return inString;
            }
            int capacity = inString.length();
            if (newPattern.length() > oldPattern.length()) {
                capacity += 16;
            }
            StringBuilder sb = new StringBuilder(capacity);
            int pos = 0;
            int patLen = oldPattern.length();
            while (index >= 0) {
                sb.append(inString, pos, index);
                sb.append(newPattern);
                pos = index + patLen;
                index = inString.indexOf(oldPattern, pos);
            }
            sb.append(inString, pos, inString.length());
            return sb.toString();
        }
        return inString;
    }

    public String[] array2TreeArray(String[] array, String combineString) {
        String[] result = new String[array.length];
        return result;
    }

    public static int itemLike(List<String> list, String value) {
        if (ListTool.ok(list)) {
            for (int i = 0; i < list.size(); ++i) {
                if (!StringTool.ok(list.get(i)) || !list.get(i).contains(value)) continue;
                return i;
            }
        }
        return -1;
    }

    public static void main(String[] args) {
        String[] array = new String[]{"1", "3", "5"};
        String[] array1 = Arrays.copyOf(array, 0);
        String[] array2 = Arrays.copyOf(array, 1);
        BigDecimal num = new BigDecimal("1.5393");
        System.out.println(num);
        String x = "123";
        String y = "";
        Alog.i(StringTool.ok(x, y));
    }
}

