/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.systems.process;

import java.util.Optional;

public class ProcessTool {
    public static boolean isProcessRunning(long pid) {
        return ProcessHandle.of(pid).isPresent();
    }

    public static ProcessResult killProcess(long pid) {
        Optional<ProcessHandle> processOpt = ProcessHandle.of(pid);
        if (processOpt.isEmpty()) {
            return ProcessResult.NOT_FOUND;
        }
        return processOpt.get().destroy() ? ProcessResult.SUCCESS : ProcessResult.FAILED;
    }

    public static ProcessResult killProcessForcibly(long pid) {
        Optional<ProcessHandle> processOpt = ProcessHandle.of(pid);
        if (processOpt.isEmpty()) {
            return ProcessResult.NOT_FOUND;
        }
        return processOpt.get().destroyForcibly() ? ProcessResult.SUCCESS : ProcessResult.FAILED;
    }

    public static String getProcessInfo(long pid) {
        return ProcessHandle.of(pid).map(p -> String.format("PID: %d, \u8fd0\u884c\u4e2d: %s, \u547d\u4ee4: %s", p.pid(), p.isAlive(), p.info().commandLine().orElse("\u672a\u77e5"))).orElse("\u8fdb\u7a0b\u4e0d\u5b58\u5728");
    }

    public static long getCurrentProcessId() {
        return ProcessHandle.current().pid();
    }

    public static enum ProcessResult {
        SUCCESS("\u64cd\u4f5c\u6210\u529f"),
        NOT_FOUND("\u8fdb\u7a0b\u4e0d\u5b58\u5728"),
        FAILED("\u64cd\u4f5c\u5931\u8d25");

        private final String message;

        private ProcessResult(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

