/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.ios.dirs;

import com.yuzhyn.azylee.core.datas.exceptions.ExceptionTool;
import com.yuzhyn.azylee.core.ios.files.FileTool;
import com.yuzhyn.azylee.core.logs.Alog;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;

public class DirTool {
    public static boolean isExist(String path) {
        try {
            File file = new File(path);
            return file.exists() && file.isDirectory();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String parent(String path) {
        try {
            File file = new File(path);
            String strParentDirectory = file.getParent();
            return strParentDirectory;
        }
        catch (Exception ex) {
            Alog.e(ex.getMessage());
            return path;
        }
    }

    public static boolean create(String path) {
        if (!DirTool.isExist(path)) {
            try {
                File file = new File(path);
                return file.mkdirs();
            }
            catch (Exception ex) {
                Alog.e(ex.getMessage());
                return false;
            }
        }
        return true;
    }

    public static String combine(String path1, String path2) {
        if (path1.endsWith(File.separator) || path2.startsWith(File.separator)) {
            return path1 + path2;
        }
        return path1 + File.separator + path2;
    }

    public static String combine(String ... paths) {
        if (paths.length > 0) {
            String result = paths[0];
            for (int i = 1; i < paths.length; ++i) {
                result = DirTool.combine(result, paths[i]);
            }
            return result;
        }
        return "";
    }

    public static boolean delete(String path) {
        File dirFile;
        if (!((String)path).endsWith(File.separator)) {
            path = (String)path + File.separator;
        }
        if (!(dirFile = new File((String)path)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = FileTool.delete(files[i].getAbsolutePath())) : files[i].isDirectory() && !(flag = DirTool.delete(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static boolean move(String source, String target) {
        Path sourceDirectory = Paths.get(source, new String[0]);
        Path targetDirectory = Paths.get(target, new String[0]);
        try {
            List<Object> paths = new ArrayList();
            try {
                paths = Files.walk(sourceDirectory, new FileVisitOption[0]).toList();
            }
            catch (Exception e) {
                Alog.e(ExceptionTool.getStackTrace(e));
            }
            paths.forEach(sourcePath -> {
                try {
                    Path targetPath;
                    if (Files.exists(sourcePath, new LinkOption[0]) && Files.notExists(targetPath = targetDirectory.resolve(sourceDirectory.relativize((Path)sourcePath)), new LinkOption[0])) {
                        Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    Alog.e(ExceptionTool.getStackTrace(e));
                }
            });
        }
        catch (Exception e) {
            Alog.e(ExceptionTool.getStackTrace(e));
        }
        return true;
    }

    public static void main(String[] args) {
    }
}

