/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.ios.zips;

import com.yuzhyn.azylee.core.ios.dirs.DirTool;
import com.yuzhyn.azylee.core.ios.files.FileTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipTool {
    public static boolean zip() throws IOException {
        int len1;
        int len;
        FileOutputStream outputStream = new FileOutputStream("f://test.zip");
        ZipOutputStream out = new ZipOutputStream(outputStream);
        FileInputStream fis = new FileInputStream("F://video.mp4");
        out.putNextEntry(new ZipEntry("\u89c6\u9891.mp4"));
        byte[] buffer = new byte[1024];
        while ((len = fis.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        fis.close();
        FileInputStream fis1 = new FileInputStream("F://picture.jpg");
        out.putNextEntry(new ZipEntry("\u56fe\u7247.jpg"));
        byte[] buffer1 = new byte[1024];
        while ((len1 = fis1.read(buffer1)) > 0) {
            out.write(buffer1, 0, len1);
        }
        out.closeEntry();
        fis1.close();
        out.close();
        return true;
    }

    public static void unzip(String zipFilePath, String targetPath, String targetFolder, Function<Map<String, Object>, Boolean> callback) throws IOException {
        String finalTargetPath = DirTool.combine(targetPath, targetFolder);
        if (!DirTool.create(finalTargetPath)) {
            throw new IOException("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25");
        }
        if (!FileTool.isExist(zipFilePath)) {
            throw new IOException("\u672a\u53d1\u73b0zip\u6587\u4ef6");
        }
        Integer fileCount = 0;
        Integer fileIndex = 0;
        Long curFileSize = 0L;
        Long curFileRead = 0L;
        File file = new File(zipFilePath);
        ZipFile zipFile = new ZipFile(file, Charset.forName("GBK"));
        Enumeration<? extends ZipEntry> zipE = zipFile.entries();
        fileCount = zipFile.size();
        while (zipE.hasMoreElements()) {
            Integer n = fileIndex;
            fileIndex = fileIndex + 1;
            curFileRead = 0L;
            ZipEntry zipEntry = zipE.nextElement();
            String savePath = DirTool.combine(finalTargetPath, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                DirTool.create(savePath);
                continue;
            }
            File uFile = new File(savePath);
            FileTool.delete(savePath);
            uFile.createNewFile();
            curFileSize = zipEntry.getSize();
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            try (FileOutputStream ofs = new FileOutputStream(uFile);){
                int length;
                byte[] bytes = new byte[1024];
                while ((length = inputStream.read(bytes, 0, bytes.length)) != -1) {
                    ofs.write(bytes, 0, length);
                    boolean isContinue = callback.apply(Map.of("fileCount", fileCount, "fileIndex", fileIndex, "curFileSize", curFileSize, "curFileRead", curFileRead = Long.valueOf(curFileRead + (long)length), "curFileName", zipEntry.getName()));
                    if (isContinue) continue;
                    throw new IOException("user break");
                }
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        callback.apply(Map.of("fileCount", fileCount, "fileIndex", fileIndex, "curFileSize", curFileSize, "curFileRead", curFileRead, "curFileName", ""));
    }

    public static void main(String[] args) throws IOException {
    }
}

