/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.configs.rocketmq;

import com.yuzhyn.azylee.core.configs.rocketmq.RockermqConsumerConfig;
import com.yuzhyn.azylee.core.configs.rocketmq.RockermqProducerConfig;
import com.yuzhyn.azylee.core.configs.rocketmq.RocketmqBaseConfig;
import com.yuzhyn.azylee.core.datas.collections.ListTool;
import java.util.List;
import java.util.Optional;

public class RocketmqConfig {
    private RocketmqBaseConfig config;
    private List<RockermqProducerConfig> producer;
    private List<RockermqConsumerConfig> consumer;

    public RockermqProducerConfig getProducer(String name) {
        Optional<RockermqProducerConfig> data;
        String upperName = name.toUpperCase();
        RockermqProducerConfig result = this.getDefaultProducer();
        if (ListTool.ok(this.producer) && (data = this.producer.stream().filter(p -> p.getName().toUpperCase().equals(upperName)).findFirst()).isPresent()) {
            RockermqProducerConfig record = data.get();
            result.setName(record.getName());
            result.setGroup(record.getGroup());
            result.setTopic(record.getTopic());
            result.setTag(record.getTag());
        }
        return result;
    }

    private RockermqProducerConfig getDefaultProducer() {
        RockermqProducerConfig result = new RockermqProducerConfig();
        if (this.config != null) {
            result.setName(this.config.getNamesrvAddr());
            result.setGroup(this.config.getProducerGroup());
            result.setNamesrvAddr(this.config.getNamesrvAddr());
            result.setSendMsgTimeout(this.config.getSendMsgTimeout());
        }
        return result;
    }

    public RockermqConsumerConfig getConsumer(String name) {
        Optional<RockermqConsumerConfig> data;
        String upperName = name.toUpperCase();
        RockermqConsumerConfig result = this.getDefaultConsumer();
        if (ListTool.ok(this.consumer) && (data = this.consumer.stream().filter(p -> p.getName().toUpperCase().equals(upperName)).findFirst()).isPresent()) {
            RockermqConsumerConfig record = data.get();
            result.setName(record.getName());
            result.setGroup(record.getGroup());
            result.setTopic(record.getTopic());
            result.setTag(record.getTag());
        }
        return result;
    }

    private RockermqConsumerConfig getDefaultConsumer() {
        RockermqConsumerConfig result = new RockermqConsumerConfig();
        if (this.config != null) {
            result.setName(this.config.getNamesrvAddr());
            result.setGroup(this.config.getConsumerGroup());
            result.setNamesrvAddr(this.config.getNamesrvAddr());
        }
        return result;
    }

    public RocketmqBaseConfig getConfig() {
        return this.config;
    }

    public void setConfig(RocketmqBaseConfig config) {
        this.config = config;
    }

    public List<RockermqProducerConfig> getProducer() {
        return this.producer;
    }

    public void setProducer(List<RockermqProducerConfig> producer) {
        this.producer = producer;
    }

    public List<RockermqConsumerConfig> getConsumer() {
        return this.consumer;
    }

    public void setConsumer(List<RockermqConsumerConfig> consumer) {
        this.consumer = consumer;
    }
}

