/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.datas.datetimes;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public enum DateTimeFormatPattern {
    SHORT_MONTH("MM"),
    SHORT_YEAR_MONTH("yyyyMM"),
    SHORT_DATE("yyyyMMdd"),
    NORMAL_YEAR_MONTH("yyyy-MM"),
    NORMAL_DATE("yyyy-MM-dd"),
    SHORT_DATETIME("yyyyMMddHHmmss"),
    NORMAL_DATETIME("yyyy-MM-dd HH:mm:ss"),
    NORMAL_DATETIME_SP("yyyy-M-d H:m:s"),
    NORMAL_DATETIME_MS("yyyy-MM-dd HH:mm:ss.SSS"),
    NORMAL_TIME_MS("HH:mm:ss.SSS"),
    NORMAL_DATETIME_TIMEZONE("yyyy-MM-dd'T'HH:mm:ss" + DateTimeFormatPattern.getTimeZone());

    private static String timeZone;
    String pattern;

    public static String[] getDateTimePattern() {
        return new String[]{NORMAL_DATETIME.getPattern(), NORMAL_DATETIME_SP.getPattern(), SHORT_DATETIME.getPattern()};
    }

    public static String getTimeZone() {
        if (timeZone == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("Z");
            sdf.setTimeZone(TimeZone.getDefault());
            timeZone = sdf.format(new Date());
        }
        return timeZone;
    }

    private DateTimeFormatPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

