/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.datas.ids;

import com.yuzhyn.azylee.core.datas.collections.ListTool;
import com.yuzhyn.azylee.core.datas.numbers.IntTool;
import com.yuzhyn.azylee.core.datas.numbers.RandomTool;
import java.util.Arrays;
import java.util.List;

public class SnowFlake {
    Long MAX = Long.MAX_VALUE;
    private long workerId;
    private long datacenterId;
    private long sequence;
    private long twepoch = 1609430400000L;
    private long workerIdBits = 5L;
    private long datacenterIdBits = 5L;
    private long sequenceBits = 12L;
    private long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.workerIdBits;
    private long maxDatacenterId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.datacenterIdBits;
    private long workerIdShift = this.sequenceBits;
    private long datacenterIdShift = this.sequenceBits + this.workerIdBits;
    private long timestampLeftShift = this.sequenceBits + this.workerIdBits + this.datacenterIdBits;
    private long sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.sequenceBits;
    private long lastTimestamp = -1L;

    public long getWorkerId() {
        return this.workerId;
    }

    public long getDatacenterId() {
        return this.datacenterId;
    }

    public long getTimestamp() {
        return System.currentTimeMillis();
    }

    public SnowFlake(long datacenterId, long workerId) {
        this(datacenterId, workerId, 0L);
    }

    public SnowFlake(long datacenterId, long workerId, long sequence) {
        if (workerId > this.maxWorkerId || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", this.maxWorkerId));
        }
        if (datacenterId > this.maxDatacenterId || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", this.maxDatacenterId));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
        this.sequence = sequence;
    }

    private synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            System.err.printf("clock is moving backwards. Rejecting requests until %d.", this.lastTimestamp);
            throw new RuntimeException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << (int)this.timestampLeftShift | this.datacenterId << (int)this.datacenterIdShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    public synchronized long next() {
        return this.nextId();
    }

    public synchronized String nexts() {
        return String.valueOf(this.nextId());
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public static int[] createDataCenterIdAndWorkerId(List<Integer> currentDataCenterIds, List<Integer> currentWorkerIds, boolean random) {
        int[] result = new int[]{-1, -1};
        List<Integer> dataCenterIds = IntTool.createIntegerList(0, 31);
        List<Integer> workerIds = IntTool.createIntegerList(0, 31);
        if (ListTool.ok(currentDataCenterIds)) {
            dataCenterIds.removeAll(currentDataCenterIds);
        }
        if (ListTool.ok(currentWorkerIds)) {
            workerIds.removeAll(currentWorkerIds);
        }
        if (ListTool.ok(dataCenterIds)) {
            result[0] = random ? dataCenterIds.get(RandomTool.get(0, dataCenterIds.size() - 1)).intValue() : dataCenterIds.get(0).intValue();
        }
        if (ListTool.ok(workerIds)) {
            result[1] = random ? workerIds.get(RandomTool.get(0, workerIds.size() - 1)).intValue() : workerIds.get(0).intValue();
        }
        return result;
    }

    public static void main(String[] args) {
        List<Integer> dcs = Arrays.asList(0, 0, 0, 0);
        List<Integer> wks = Arrays.asList(0, 1, 2, 1);
        for (int i = 0; i < 100; ++i) {
            int[] rs = SnowFlake.createDataCenterIdAndWorkerId(dcs, wks, true);
            System.out.println("data-center-id: " + rs[0] + ", worker-id: " + rs[1]);
        }
    }
}

