/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.datas.regexs;

import com.yuzhyn.azylee.core.logs.Alog;
import java.util.regex.Pattern;

public enum RegexPattern {
    GENERAL(Pattern.compile("^\\w+$")),
    POSITIVE_INTEGER(Pattern.compile("^[1-9]\\d*$")),
    POSITIVE_FLOAT(Pattern.compile("^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*$")),
    POSITIVE_INTEGER_AND_ZERO(Pattern.compile("^[0-9]*[0-9][0-9]*$")),
    REAL_POSITIVE_INTEGER_AND_ZERO(Pattern.compile("^[0-9]*[0-9][0-9]*(\\.?0+)*$")),
    POSITIVE_NUMBER_AND_ZERO(Pattern.compile("^[0-9]+([.]{1}[0-9]+){0,1}$")),
    NUMBER(Pattern.compile("^-?[0-9]+([.]{1}[0-9]+){0,1}$")),
    NONNEGATIVE_DECIMAL(Pattern.compile("^([1-9]\\d*(\\.\\d{0,4})?)|(0\\.\\d{0,4})$")),
    NONNEGATIVE_DECIMAL_ZERO(Pattern.compile("^([1-9]\\d*(\\.\\d{0,4})?)|(0(\\.\\d{0,4})?)$"));

    Pattern pattern;

    private RegexPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean isMatch(CharSequence content) {
        if (content != null && this.pattern != null) {
            return this.pattern.matcher(content).matches();
        }
        return false;
    }

    public static void main(String[] args) {
        Alog.v(GENERAL.getPattern().pattern());
        Alog.v("zhangsanfeng00111 " + GENERAL.isMatch("zhangsanfeng00111"));
        Alog.v("zhangsanfeng00111\u5f20 " + GENERAL.isMatch("zhangsanfeng00111\u5f20"));
        Alog.v("zhangsanfeng00111\u5f20~ " + GENERAL.isMatch("zhangsanfeng00111\u5f20~"));
        Alog.v("zhangsanfeng_00111 " + GENERAL.isMatch("zhangsanfeng_00111"));
        Alog.v("zhangsanfeng_+00111 " + GENERAL.isMatch("zhangsanfeng_+00111"));
    }
}

