/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.ios.files;

import com.yuzhyn.azylee.core.datas.encrypts.HexTool;
import com.yuzhyn.azylee.core.datas.encrypts.Sha1Tool;
import com.yuzhyn.azylee.core.logs.Alog;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;

public class FileCharCodeTool {
    public static String md5(File file) {
        String string;
        block9: {
            InputStream stream = Files.newInputStream(file.toPath(), StandardOpenOption.READ);
            try {
                int len;
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] buf = new byte[8192];
                while ((len = stream.read(buf)) > 0) {
                    digest.update(buf, 0, len);
                }
                string = HexTool.toHex(digest.digest());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return "";
                }
            }
            stream.close();
        }
        return string;
    }

    public static String md5(String pathName) {
        return FileCharCodeTool.md5(new File(pathName));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String sha1(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            String string;
            block13: {
                FileChannel ch = in.getChannel();
                try {
                    MessageDigest messagedigest = MessageDigest.getInstance("SHA-1");
                    MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
                    messagedigest.update(byteBuffer);
                    string = Sha1Tool.encrypt(messagedigest.digest());
                    if (ch == null) break block13;
                }
                catch (Throwable throwable) {
                    if (ch != null) {
                        try {
                            ch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ch.close();
            }
            return string;
        }
        catch (Exception ex) {
            Alog.e(ex.getMessage());
            return "";
        }
    }

    public static String sha1(String pathName) {
        return FileCharCodeTool.sha1(new File(pathName));
    }

    public static void main(String[] args) {
    }
}

