/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.ios.files;

import com.yuzhyn.azylee.core.datas.strings.StringConst;
import com.yuzhyn.azylee.core.datas.strings.StringTool;
import com.yuzhyn.azylee.core.ios.dirs.DirTool;
import com.yuzhyn.azylee.core.logs.Alog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public class FileTool {
    public static boolean isExist(String pathName) {
        try {
            File file = new File(pathName);
            return file.exists() && file.isFile();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean create(String pathName) {
        if (!FileTool.isExist(pathName)) {
            try {
                File file;
                if (DirTool.create(DirTool.parent(pathName)) && (file = new File(pathName)).createNewFile()) {
                    return FileTool.isExist(pathName);
                }
            }
            catch (Exception ex) {
                Alog.e(ex.getMessage());
            }
            return false;
        }
        return true;
    }

    public static boolean recreate(String pathName) {
        if (FileTool.delete(pathName)) {
            return FileTool.create(pathName);
        }
        return false;
    }

    public static boolean delete(String pathName) {
        if (FileTool.isExist(pathName)) {
            try {
                File file = new File(pathName);
                if (file.delete()) {
                    return true;
                }
                if (file.delete()) {
                    return true;
                }
                if (file.delete()) {
                    return true;
                }
                if (FileTool.isExist(pathName)) {
                    file.deleteOnExit();
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public static boolean copy(String source, String target) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean copy(String source, String target, boolean overwrite) {
        if (overwrite) {
            return FileTool.copy(source, target);
        }
        return FileTool.isExist(target);
    }

    public static boolean move(String source, String target) {
        boolean copyFlag = FileTool.copy(source, target);
        if (copyFlag) {
            boolean bl = FileTool.delete(source);
        }
        return copyFlag;
    }

    public static boolean rename(String source, String target) {
        File oldFile = new File(source);
        File newFile = new File(target);
        return oldFile.renameTo(newFile);
    }

    public static boolean inputStreamToFile(InputStream inputStream, String targetFilePath, boolean overwrite) {
        try {
            int index;
            if (FileTool.isExist(targetFilePath) && !overwrite) {
                return true;
            }
            byte[] bytes = new byte[1024];
            FileOutputStream downloadFile = new FileOutputStream(targetFilePath);
            while ((index = inputStream.read(bytes)) != -1) {
                downloadFile.write(bytes, 0, index);
                downloadFile.flush();
            }
            downloadFile.close();
            inputStream.close();
            return true;
        }
        catch (Exception ex) {
            Alog.e(ex.getMessage());
            return false;
        }
    }

    public static String getExt(String s) {
        if (StringTool.ok(s)) {
            String fileName = s;
            int fileNameIndex = s.lastIndexOf(StringConst.FILE_SEPARATOR);
            if (fileNameIndex > 0) {
                fileName = s.substring(fileNameIndex + 1);
            }
            if (StringTool.ok(fileName)) {
                int extNameIndex = fileName.lastIndexOf(".");
                String extName = fileName.substring(extNameIndex + 1);
                return extName;
            }
        }
        return "";
    }

    public static String getNameWithoutExt(String s) {
        String fileName;
        if (StringTool.ok(s) && StringTool.ok(fileName = FileTool.getName(s))) {
            int nameIndex = fileName.lastIndexOf(".");
            String name = fileName.substring(0, nameIndex);
            return name;
        }
        return "";
    }

    public static String getName(String s) {
        if (StringTool.ok(s)) {
            String fileName = s;
            int fileNameIndex = s.lastIndexOf(StringConst.FILE_SEPARATOR);
            if (fileNameIndex > -1) {
                fileName = s.substring(fileNameIndex + 1);
            }
            return fileName;
        }
        return "";
    }

    public static String getPath(String s) {
        if (StringTool.ok(s)) {
            String fileName = s;
            int fileNameIndex = s.lastIndexOf(StringConst.FILE_SEPARATOR);
            if (fileNameIndex > -1) {
                fileName = s.substring(0, fileNameIndex);
            }
            return fileName;
        }
        return "";
    }

    public static long getSize(String file) {
        try {
            if (FileTool.isExist(file)) {
                return new File(file).length();
            }
        }
        catch (Exception ex) {
            Alog.e(ex.getMessage());
        }
        return 0L;
    }

    public static void main(String[] args) {
        Alog.i(FileTool.getPath("test.dxf"));
        Alog.i(FileTool.getPath("test\\test.dxf"));
        Alog.i(FileTool.getExt("\\test.dxf"));
        Alog.i(FileTool.getNameWithoutExt("/test/test.dxf"));
        Alog.i(FileTool.getNameWithoutExt("E:\\test\\test.dxf"));
        Alog.i("-----------------------------------");
        Alog.i(FileTool.getExt("E:\\test\\test.dxf"));
    }
}

