/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.ios.files;

import com.yuzhyn.azylee.core.datas.collections.ListTool;
import com.yuzhyn.azylee.core.datas.datetimes.DateTimeFormat;
import com.yuzhyn.azylee.core.datas.datetimes.DateTimeFormatPattern;
import com.yuzhyn.azylee.core.ios.dirs.DirTool;
import com.yuzhyn.azylee.core.ios.files.FileFindTool;
import com.yuzhyn.azylee.core.ios.files.FileTool;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class FileVersionManager {
    private static final String FILE_SP = ".V.";
    private static final String FILE_EXT = ".AZLFVM";
    private String fileName = null;
    private String pathName = null;
    private String path = null;
    private int versionSize = 1;

    private FileVersionManager() {
    }

    public FileVersionManager(String pathName) {
        this(pathName, 5);
    }

    public FileVersionManager(String pathName, int versionSize) {
        this.pathName = pathName;
        this.fileName = FileTool.getName(pathName);
        this.path = FileTool.getPath(pathName);
        this.versionSize = versionSize;
    }

    private String nextName() {
        return this.fileName + FILE_SP + DateTimeFormat.toStr(new Date(), DateTimeFormatPattern.SHORT_DATETIME) + FILE_EXT;
    }

    public String create() {
        String name = this.nextName();
        FileTool.copy(this.pathName, DirTool.combine(this.path, name));
        this.clean(this.versionSize);
        return name;
    }

    public void clean() {
        this.clean(0);
    }

    public void clean(int retain) {
        List<String> list = this.versionList();
        if (ListTool.ok(list)) {
            for (int i = 0; i < list.size() - retain; ++i) {
                FileTool.delete(DirTool.combine(this.path, list.get(i)));
            }
        }
    }

    public List<String> versionList() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> files = FileFindTool.getFiles(this.path);
        if (ListTool.ok(files)) {
            for (String file : files) {
                if (!file.startsWith(this.fileName) || !file.contains(FILE_SP) || !file.endsWith(FILE_EXT)) continue;
                result.add(file);
            }
        }
        return result.stream().sorted().collect(Collectors.toList());
    }
}

