/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.ios.imgs;

import com.yuzhyn.azylee.core.ios.files.FileTool;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImgTool {
    public static BufferedImage rotateImage(BufferedImage bufferedimage, int degree) {
        int w = bufferedimage.getWidth();
        int h = bufferedimage.getHeight();
        int type = bufferedimage.getColorModel().getTransparency();
        BufferedImage img = new BufferedImage(w, h, type);
        Graphics2D graphics2d = img.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2d.setPaint(Color.WHITE);
        graphics2d.fillRect(0, 0, w, h);
        graphics2d.rotate(Math.toRadians(degree), w / 2, h / 2);
        graphics2d.drawImage(bufferedimage, 0, 0, Color.WHITE, null);
        graphics2d.dispose();
        return img;
    }

    public static void saveFile(BufferedImage image, String file) throws IOException {
        ImageIO.write((RenderedImage)image, FileTool.getExt(file), new File(file));
    }

    public static void main(String[] args) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File("E:\\images\\0002.png"));
        BufferedImage rImage = ImgTool.rotateImage(bufferedImage, 45);
        ImgTool.saveFile(rImage, "E:\\images\\0002_0002.png");
    }
}

