/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.ios.txts;

import com.yuzhyn.azylee.core.ios.files.FileTool;
import com.yuzhyn.azylee.core.ios.txts.TxtTool;
import java.util.List;

public class IniTool {
    public static String read(String fileName, String section, String key, String defaultValue) {
        List<String> lines = TxtTool.readLine(fileName);
        int[] position = IniTool.position(lines, section, key);
        if (position[0] != -1 && position[1] != -1) {
            String line = lines.get(position[1]);
            String resultValue = line.substring(line.indexOf("=") + 1);
            return resultValue;
        }
        return defaultValue;
    }

    public static boolean write(String fileName, String section, String key, String value) {
        List<String> lines;
        int[] position;
        if (!FileTool.isExist(fileName)) {
            FileTool.create(fileName);
        }
        if ((position = IniTool.position(lines = TxtTool.readLine(fileName), section, key))[0] != -1) {
            if (position[1] != -1) {
                String line = key + "=" + value;
                lines.set(position[1], line);
            } else {
                String line = key + "=" + value;
                lines.add(position[0] + 1, line);
            }
        } else {
            lines.add("[" + section + "]");
            lines.add(key + "=" + value);
        }
        return IniTool.saveFile(fileName, lines);
    }

    private static int[] position(List<String> lines, String section, String key) {
        int sectionIndex = -1;
        int keyIndex = -1;
        String currentSection = "";
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.startsWith("[") && line.endsWith("]") && (currentSection = line.substring(1, line.length() - 1)).equals(section)) {
                sectionIndex = i;
            }
            if (!currentSection.equals(section) || !line.startsWith(key + "=")) continue;
            keyIndex = i;
            break;
        }
        return new int[]{sectionIndex, keyIndex};
    }

    private static boolean saveFile(String file, List<String> lines) {
        String oldFile = file + ".old";
        FileTool.delete(oldFile);
        FileTool.move(file, oldFile);
        TxtTool.create(file, lines);
        if (FileTool.isExist(file) && FileTool.getSize(file) > 0L) {
            if (FileTool.delete(oldFile)) {
                return true;
            }
        } else {
            FileTool.delete(file);
            FileTool.move(oldFile, file);
        }
        return false;
    }
}

