/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.systems.linuxs.shell;

import com.yuzhyn.azylee.core.datas.strings.StringTool;
import com.yuzhyn.azylee.core.systems.linuxs.shell.LinuxShellTool;
import java.util.List;

public class LinuxFirewallTool {
    public static boolean state() {
        String cmd = "firewall-cmd --state";
        List<String> result = LinuxShellTool.sh(cmd);
        return StringTool.itemLike(result, "running") > -1;
    }

    public static boolean queryPort(int port, String protocol) {
        String cmd = "firewall-cmd --query-port=" + port + "/" + protocol;
        List<String> result = LinuxShellTool.sh(cmd);
        return StringTool.itemLike(result, "yes") > -1;
    }

    public static boolean addPort(int port, String protocol) {
        String cmd = "firewall-cmd --permanent --add-port=" + port + "/" + protocol;
        List<String> result = LinuxShellTool.sh(cmd);
        return StringTool.itemLike(result, "success") > -1;
    }

    public static boolean removePort(int port, String protocol) {
        String cmd = "firewall-cmd --permanent --remove-port=" + port + "/" + protocol;
        List<String> result = LinuxShellTool.sh(cmd);
        return StringTool.itemLike(result, "success") > -1;
    }

    public static boolean reload() {
        String cmd = "firewall-cmd --reload";
        List<String> result = LinuxShellTool.sh(cmd);
        return StringTool.itemLike(result, "success") > -1;
    }

    public static boolean start() {
        String cmd = "service firewalld start";
        List<String> result = LinuxShellTool.sh(cmd);
        return StringTool.itemLike(result, "success") > -1;
    }

    public static boolean restart() {
        String cmd = "service firewalld restart";
        List<String> result = LinuxShellTool.sh(cmd);
        return StringTool.itemLike(result, "success") > -1;
    }

    public static boolean stop() {
        String cmd = "service firewalld stop";
        List<String> result = LinuxShellTool.sh(cmd);
        return StringTool.itemLike(result, "success") > -1;
    }
}

