/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.systems.linuxs.status;

import com.yuzhyn.azylee.core.systems.models.MemoryInfo;
import com.yuzhyn.azylee.core.threads.sleeps.Sleep;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class LinuxSystemStatusTool {
    public static float getCpuUseRatio() {
        try {
            File file = new File("/proc/stat");
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            StringTokenizer token = new StringTokenizer(br.readLine());
            token.nextToken();
            long user1 = Long.parseLong(token.nextToken());
            long nice1 = Long.parseLong(token.nextToken());
            long system1 = Long.parseLong(token.nextToken());
            long idle1 = Long.parseLong(token.nextToken());
            long iowait1 = Long.parseLong(token.nextToken());
            long irq1 = Long.parseLong(token.nextToken());
            long softirq1 = Long.parseLong(token.nextToken());
            Sleep.s(1L);
            br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            token = new StringTokenizer(br.readLine());
            token.nextToken();
            long user2 = Long.parseLong(token.nextToken());
            long nice2 = Long.parseLong(token.nextToken());
            long system2 = Long.parseLong(token.nextToken());
            long idle2 = Long.parseLong(token.nextToken());
            long iowait2 = Long.parseLong(token.nextToken());
            long irq2 = Long.parseLong(token.nextToken());
            long softirq2 = Long.parseLong(token.nextToken());
            float useTime = user2 + nice2 + system2 + idle2 + iowait2 + irq2 + softirq2 - (user1 + nice1 + system1 + idle1 + iowait1 + irq1 + softirq1);
            float freeTime = idle2 - idle1;
            float useRatio = 1.0f - freeTime / useTime;
            return useRatio;
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public static MemoryInfo getRam() {
        MemoryInfo memoryInfo = new MemoryInfo();
        try {
            File file = new File("/proc/meminfo");
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String str = null;
            String value = null;
            StringTokenizer token = null;
            while ((str = br.readLine()) != null) {
                token = new StringTokenizer(str);
                if (!token.hasMoreTokens()) continue;
                str = token.nextToken();
                if (!token.hasMoreTokens()) continue;
                value = token.nextToken();
                if (str.equalsIgnoreCase("MemTotal:")) {
                    memoryInfo.setMemTotal(Long.parseLong(value));
                    continue;
                }
                if (str.equalsIgnoreCase("MemFree:")) {
                    memoryInfo.setMemFree(Long.parseLong(value));
                    continue;
                }
                if (str.equalsIgnoreCase("SwapTotal:")) {
                    memoryInfo.setSwapTotal(Long.parseLong(value));
                    continue;
                }
                if (!str.equalsIgnoreCase("SwapFree:")) continue;
                memoryInfo.setSwapFree(Long.parseLong(value));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return memoryInfo;
    }
}

