/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.dbs.lite;

import com.yuzhyn.azylee.core.datas.strings.StringTool;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JdbcTool {
    private String type;
    private String url;
    private String host;
    private int port;
    private String urlParams;
    private String driverClass;
    private String username;
    private String password;
    private String schema;

    public JdbcTool(String _type, String _url, String _driverClass, String _username, String _password) {
        this.type = _type;
        this.url = _url;
        this.driverClass = _driverClass;
        this.username = _username;
        this.password = _password;
    }

    public JdbcTool(String _type, String _host, int _port, String _schema, String _urlParams, String _driverClass, String _username, String _password) {
        this.type = _type;
        this.host = _host;
        this.port = _port;
        this.schema = _schema;
        this.urlParams = _urlParams;
        this.driverClass = _driverClass;
        this.username = _username;
        this.password = _password;
        this.generateUrl();
    }

    private void generateUrl() {
        switch (this.type) {
            default: 
        }
        String _url = "jdbc:" + this.type + "://" + this.host + ":" + this.port + "/" + this.schema;
        if (StringTool.ok(this.urlParams)) {
            _url = _url + "?" + this.urlParams;
        }
        this.url = _url;
    }

    public List<Map> query(String sql) throws ClassNotFoundException, SQLException {
        ArrayList<Map> resultList = new ArrayList<Map>();
        Class.forName(this.driverClass);
        Connection conn = DriverManager.getConnection(this.url, this.username, this.password);
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int count = rsMetaData.getColumnCount();
        while (rs.next()) {
            HashMap<String, Object> record = new HashMap<String, Object>();
            for (int i = 1; i <= count; ++i) {
                String label = rsMetaData.getColumnLabel(i);
                Object value = rs.getObject(label);
                record.put(label, value);
            }
            resultList.add(record);
        }
        return resultList;
    }

    public Object queryCell(String sql, int index, String columnName) throws SQLException, ClassNotFoundException {
        List<Map> rows = this.query(sql);
        if (rows.size() > index) {
            return rows.get(index).get(columnName);
        }
        return null;
    }

    public Object queryFirstCell(String sql, String columnName) throws SQLException, ClassNotFoundException {
        return this.queryCell(sql, 0, columnName);
    }

    public Object queryFirstCell(String sql) throws SQLException, ClassNotFoundException {
        Iterator iterator;
        List<Map> rows = this.query(sql);
        if (rows.size() > 0 && (iterator = rows.get(0).values().iterator()).hasNext()) {
            Object object = iterator.next();
            return object;
        }
        return null;
    }
}

