/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.core.datas.numbers;

import com.yuzhyn.azylee.core.datas.collections.ListTool;
import com.yuzhyn.azylee.core.datas.strings.StringFillTool;
import com.yuzhyn.azylee.core.logs.Alog;
import java.util.ArrayList;
import java.util.List;

public class IntTool {
    public static List<Integer> createIntegerList(int begin, int end) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int min = Math.min(begin, end);
        int max = Math.max(begin, end);
        for (int i = min; i <= max; ++i) {
            list.add(i);
        }
        return list;
    }

    public static int parse(String s, int defaultValue) {
        int num = defaultValue;
        try {
            num = Integer.parseInt(s);
        }
        catch (Exception ex) {
            Alog.e(ex.getMessage());
        }
        return num;
    }

    public static Integer parse(String s) {
        Integer num = null;
        try {
            num = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public static int[] convert(String[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (ListTool.ok(array)) {
            for (String s : array) {
                Integer n = IntTool.parse(s);
                if (n == null) continue;
                list.add(n);
            }
        }
        int[] integerArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            integerArray[i] = (Integer)list.get(i);
        }
        return integerArray;
    }

    public static boolean inArray(int[] array, int number) {
        int[] nArray = array;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer item = nArray[i];
            if (item != number) continue;
            return true;
        }
        return false;
    }

    public static String toStr(int num, int length) {
        String s;
        if (length < 1) {
            length = 1;
        }
        if ((s = String.valueOf(num)).length() >= length) {
            return s;
        }
        return StringFillTool.prefixFill(s, length, "0");
    }

    public static void main(String[] args) {
    }
}

