/*
 * Decompiled with CFR 0.152.
 */
package com.yuzhyn.azylee.ext.web.mqs.rocketmq;

import com.yuzhyn.azylee.core.configs.rocketmq.RockermqProducerConfig;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;

public class RocketmqProducerManager {
    private static ConcurrentHashMap<String, DefaultMQProducer> producerPool = new ConcurrentHashMap();

    public static DefaultMQProducer getProducer(String name) {
        return producerPool.get(name);
    }

    public static boolean create(RockermqProducerConfig producerPart) {
        try {
            DefaultMQProducer producer = new DefaultMQProducer(producerPart.getGroup());
            producer.setNamesrvAddr(producerPart.getNamesrvAddr());
            if (producerPart.getSendMsgTimeout() > 0) {
                producer.setSendMsgTimeout(producerPart.getSendMsgTimeout());
            }
            producer.setInstanceName(String.valueOf(System.currentTimeMillis()));
            producerPool.put(producerPart.getName(), producer);
            return true;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return false;
        }
    }

    public static boolean createAndStart(RockermqProducerConfig producerPart) {
        if (RocketmqProducerManager.create(producerPart)) {
            return RocketmqProducerManager.start(producerPart.getName());
        }
        return false;
    }

    public static boolean start(String name) {
        try {
            RocketmqProducerManager.getProducer(name).start();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static SendResult send(String name, Message message) {
        SendResult result = null;
        try {
            result = RocketmqProducerManager.getProducer(name).send(message);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SendResult send(String name, Message message, long order) {
        SendResult result = null;
        try {
            result = RocketmqProducerManager.getProducer(name).send(message, (mqs, msg, arg) -> {
                long id = (Long)arg;
                long index = id % (long)mqs.size();
                return (MessageQueue)mqs.get((int)index);
            }, (Object)order);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static void shutdown(String name) {
        RocketmqProducerManager.getProducer(name).shutdown();
    }

    public static void shutdownAll() {
        if (producerPool != null && producerPool.size() > 0) {
            for (String name : producerPool.keySet()) {
                if (!producerPool.containsKey(name) || producerPool.get(name) == null) continue;
                RocketmqProducerManager.shutdown(name);
            }
        }
    }

    @PreDestroy
    public void preDestroy() {
        long now = System.currentTimeMillis();
        System.out.println("\u5173\u95ed\u6240\u6709 Rocketmq \u8fde\u63a5");
        RocketmqProducerManager.shutdownAll();
        System.out.println("\u603b\u8ba1\u7528\u65f6\uff1a" + (System.currentTimeMillis() - now));
    }
}

